# Queen Florist - Landing Page

Landing page yang menarik untuk bisnis florist "Queen Florist" dengan fitur lengkap dan responsive design.

## Fitur Utama

### 🌸 Navbar
- Logo "QUEEN Florist" dengan animasi
- Navigasi smooth scroll (Beranda, Produk, Kontak)
- Mobile responsive dengan hamburger menu

### 🎯 Hero Section
- Background image dari URL yang diberikan
- Judul menarik dengan animasi glow effect
- Tombol CTA dengan animasi hover:
  - "Lihat Produk" - smooth scroll ke section produk
  - "Chat Admin" - direct link ke WhatsApp dengan pesan default

### 📱 Kategori Produk
10 kategori dengan ikon dan animasi:
1. Standing Flower
2. Paper Flower  
3. Duka Cita
4. Bouquet
5. Wedding Car Decoration
6. Balloon Decoration
7. Kado Rustic
8. Balloon Parcel
9. Snack Bouquet
10. Tart Snack

Setiap kategori memiliki:
- Ikon Font Awesome yang sesuai
- Animasi hover yang smooth
- Smooth scroll ke produk saat diklik

### 🛒 Sistem Pemesanan
- Form order dalam popup modal
- Integrasi WhatsApp untuk pengiriman pesan
- Validasi form yang lengkap
- Opsi pengiriman (Ambil/Kirim) dengan conditional form

### 💬 Testimoni Pelanggan
- 3 testimoni dengan rating bintang
- Animasi hover yang menarik
- Design card yang modern

### 📍 Kontak & Lokasi
- Informasi alamat lengkap
- Nomor telepon dan WhatsApp
- Embed Google Maps
- Link media sosial (Instagram, TikTok)

## Teknologi yang Digunakan

- **HTML5** - Semantic markup
- **CSS3** - Modern styling dengan animasi
- **JavaScript (ES6+)** - Interaktivitas dan DOM manipulation
- **Font Awesome** - Icons
- **Responsive Design** - Mobile-first approach

## Animasi & Interaksi

### ✨ Animasi CSS
- Hero title glow effect
- Button hover dengan ripple effect
- Card animations dengan transform
- Smooth scrolling
- Gradient animations
- Loading animations

### 🎮 Interaksi JavaScript
- Mobile menu toggle
- Kategori selection
- Modal popup untuk form order
- Form validation
- WhatsApp integration
- Scroll to top button
- Touch/swipe support untuk mobile

## Responsive Design

### 📱 Mobile (< 768px)
- Hamburger menu
- Single column layout
- Touch-friendly buttons
- Optimized modal size
- Reduced font sizes

### 💻 Desktop (> 768px)
- Multi-column layout
- Hover effects
- Larger images
- Full navigation menu

## Struktur Folder

```
queen-florist/
├── index.php          # File utama
├── css/
│   └── style.css      # Stylesheet lengkap
├── js/
│   └── script.js      # JavaScript interaktif
├── assets/
│   └── (gambar-gambar)
└── README.md          # Dokumentasi
```

## Cara Penggunaan

1. **Upload ke Hosting**
   - Copy seluruh folder `queen-florist`
   - Paste ke dalam folder `htdocs` atau `public_html`
   - Akses melalui browser

2. **Konfigurasi**
   - Ubah nomor WhatsApp di `index.php` dan `script.js` jika diperlukan
   - Update link media sosial
   - Sesuaikan alamat dan Google Maps

3. **Kustomisasi**
   - Edit warna tema di `css/style.css`
   - Modifikasi teks dan konten di `index.php`
   - Tambahkan produk baru di `js/script.js`

## Fitur WhatsApp Integration

Form order akan mengirim pesan WhatsApp dengan format:
```
🌸 PEMESANAN QUEEN FLORIST 🌸

📋 Detail Pesanan:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
🏷️ Produk: [Nama Produk]
👤 Nama: [Nama Pelanggan]
📝 Catatan: [Catatan Pesanan]
🚚 Pengiriman: [Ambil/Kirim]
📍 Alamat: [Alamat Pengiriman]

📎 Gambar Produk: [Link Gambar]

Mohon konfirmasi ketersediaan dan total harga. Terima kasih! 🙏
```

## Optimasi & Performance

- Lazy loading untuk gambar
- Debounced scroll events
- Optimized animations
- Minimal external dependencies
- Compressed assets

## Browser Support

- Chrome/Chromium 60+
- Firefox 55+
- Safari 12+
- Edge 79+
- Mobile browsers (iOS Safari, Android Chrome)

## Copyright

© 2025 Queen Florist | brainmultimedia All rights reserved.

---

Dibuat dengan ❤️ oleh brainmultimedia
https://brainmultimedia.com