-- =====================================================
-- Database Setup for Agenda Management System
-- =====================================================
-- Run this script in your cPanel phpMyAdmin
-- Database name: queen_florist (or your preferred name)

-- Create database if not exists (optional)
-- CREATE DATABASE IF NOT EXISTS queen_florist;
-- USE queen_florist;

-- Drop existing table if exists (for fresh install)
DROP TABLE IF EXISTS agenda;

-- Create agenda table
CREATE TABLE agenda (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month INT NOT NULL COMMENT 'Month (1-12)',
    day INT NOT NULL COMMENT 'Day of month (1-31)',
    title VARCHAR(255) NOT NULL COMMENT 'Event title',
    description TEXT NOT NULL COMMENT 'Event description',
    is_active TINYINT(1) DEFAULT 1 COMMENT '1 for active, 0 for inactive',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation timestamp',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last update timestamp',
    
    -- Add constraints
    CONSTRAINT chk_month CHECK (month BETWEEN 1 AND 12),
    CONSTRAINT chk_day CHECK (day BETWEEN 1 AND 31),
    CONSTRAINT chk_is_active CHECK (is_active IN (0, 1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create indexes for better performance
CREATE INDEX idx_month_day ON agenda(month, day);
CREATE INDEX idx_is_active ON agenda(is_active);
CREATE INDEX idx_created_at ON agenda(created_at);

-- Insert sample data
INSERT INTO agenda (month, day, title, description, is_active) VALUES
(10, 24, 'Hari Dokter Indonesia', 'Peringatan hari dokter Indonesia untuk menghormati jasa para dokter di seluruh Indonesia', 1),
(10, 27, 'Hari Penerbangan Nasional', 'Peringatan hari penerbangan nasional Indonesia yang menandai sejarah penerbangan tanah air', 1),
(10, 28, 'Hari Sumpah Pemuda', 'Peringatan Sumpah Pemuda tahun 1928 yang menjadi tonggak persatuan bangsa Indonesia', 1),
(11, 10, 'Hari Pahlawan', 'Peringatan pertempuran Surabaya pada 10 November 1945 untuk mengenang jasa para pahlawan', 1),
(12, 22, 'Hari Ibu', 'Peringatan Hari Ibu Nasional untuk menghormati peran ibu dalam keluarga dan masyarakat', 1);

-- Create view for active events (optional)
CREATE VIEW v_active_agenda AS
SELECT 
    id,
    month,
    day,
    title,
    description,
    is_active,
    created_at,
    updated_at,
    CASE 
        WHEN month = MONTH(CURRENT_DATE) AND day >= DAY(CURRENT_DATE) THEN 'Upcoming'
        WHEN month > MONTH(CURRENT_DATE) THEN 'Upcoming'
        WHEN month < MONTH(CURRENT_DATE) THEN 'Past'
        ELSE 'Today'
    END as status
FROM agenda 
WHERE is_active = 1
ORDER BY month, day;

-- Success message
SELECT 'Database setup completed successfully!' as message, COUNT(*) as total_records FROM agenda;