# 🚀 Ngadimin Panel - Agenda Management System

Sistem manajemen agenda yang modern, responsif, dan siap digunakan untuk hosting cPanel.

## 📋 Fitur Utama

- ✅ **CRUD Lengkap** - Create, Read, Update, Delete agenda
- ✅ **Responsive Design** - Optimal di desktop, tablet, dan mobile
- ✅ **Real-time Search** - Pencarian agenda instan
- ✅ **Advanced Filtering** - Filter berdasarkan bulan dan status
- ✅ **Statistics Dashboard** - Statistik total, aktif, dan akan datang
- ✅ **Export to CSV** - Export data agenda ke format CSV
- ✅ **Toast Notifications** - Notifikasi user-friendly
- ✅ **Form Validation** - Validasi input yang komprehensif
- ✅ **Keyboard Shortcuts** - Shortcut untuk produktivitas
- ✅ **Security Features** - Rate limiting, input sanitization, XSS protection
- ✅ **Error Handling** - Penanganan error yang robust
- ✅ **Performance Optimized** - Debouncing, lazy loading, caching

## 🗂️ Struktur File

```
deploy/
├── index.html          # Halaman utama aplikasi
├── style.css           # Stylesheet lengkap dengan responsive design
├── script.js           # JavaScript dengan fitur lengkap
├── database.sql        # Script database setup
├── api/
│   ├── config.php      # Konfigurasi database dan security
│   └── agenda.php      # REST API endpoints
├── logs/               # Folder untuk error logs (auto-created)
└── README.md           # Dokumentasi ini
```

## 🛠️ Cara Install di cPanel

### 1. Upload Files
1. Login ke cPanel hosting Anda
2. Buka **File Manager**
3. Buat folder baru di `public_html` (misal: `ngadimin`)
4. Upload semua file dari folder `deploy` ke folder tersebut
5. Extract jika upload dalam format zip

### 2. Setup Database
1. Buka **MySQL Database Wizard** di cPanel
2. Buat database baru (misal: `queen_florist`)
3. Buat database user (misal: `queen_user`)
4. Grant privileges ke user untuk database tersebut
5. Buka **phpMyAdmin**
6. Pilih database yang baru dibuat
7. Klik tab **Import**
8. Upload file `database.sql`
9. Klik **Go** untuk import

### 3. Konfigurasi Database
1. Buka file `api/config.php` di File Manager
2. Update konfigurasi database:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'queen_florist');      // Ganti dengan nama database Anda
   define('DB_USER', 'queen_user');         // Ganti dengan database user Anda
   define('DB_PASS', 'your_password');      // Ganti dengan password database Anda
   ```
3. Save file

### 4. Set Permissions
1. Di File Manager, select folder `api`
2. Klik kanan → **Change Permissions**
3. Set ke **755**
4. Untuk file PHP, set ke **644**

### 5. Test Aplikasi
1. Buka browser
2. Akses: `http://yourdomain.com/ngadimin/`
3. Aplikasi siap digunakan!

## 🔧 Konfigurasi Tambahan

### Security Headers
Sudah include security headers:
- X-Content-Type-Options: nosniff
- X-Frame-Options: DENY
- X-XSS-Protection: 1; mode=block
- Referrer-Policy: strict-origin-when-cross-origin

### Rate Limiting
- 100 requests per minute per IP
- Auto-block jika melebihi limit
- File-based storage di folder `logs/`

### Error Logging
- Error logs disimpan di `logs/error.log`
- Auto-create folder jika belum ada
- Disable display errors di production

## 📱 Responsive Breakpoints

- **Mobile**: < 768px
- **Tablet**: 768px - 1024px
- **Desktop**: > 1024px

## ⌨️ Keyboard Shortcuts

- `Ctrl/Cmd + N` - Tambah agenda baru
- `Ctrl/Cmd + F` - Focus search
- `Ctrl/Cmd + E` - Export to CSV
- `Ctrl/Cmd + P` - Print
- `Esc` - Tutup modal

## 🎨 Customization

### Mengubah Warna Tema
Edit file `style.css` dan ubah CSS variables:
```css
:root {
    --primary-color: #2563eb;    /* Warna utama */
    --secondary-color: #64748b;  /* Warna sekunder */
    --success-color: #10b981;    /* Warna sukses */
    --warning-color: #f59e0b;    /* Warna peringatan */
    --danger-color: #ef4444;     /* Warna bahaya */
}
```

### Mengubah Logo dan Nama
Edit file `index.html`:
```html
<div class="logo">
    <i class="fas fa-calendar-alt"></i>
    <h1>Nama Panel Anda</h1>
</div>
```

## 🔍 API Endpoints

### GET /api/agenda.php
- Get all agenda: `GET /api/agenda.php`
- Get specific agenda: `GET /api/agenda.php?id=1`
- Filter by month: `GET /api/agenda.php?month=10`
- Filter by status: `GET /api/agenda.php?is_active=1`
- Search: `GET /api/agenda.php?search=hari`

### POST /api/agenda.php
Create new agenda:
```json
{
    "month": 10,
    "day": 28,
    "title": "Hari Sumpah Pemuda",
    "description": "Peringatan Sumpah Pemuda",
    "is_active": 1
}
```

### PUT /api/agenda.php?id=1
Update agenda:
```json
{
    "month": 10,
    "day": 28,
    "title": "Updated Title",
    "description": "Updated Description",
    "is_active": 1
}
```

### DELETE /api/agenda.php?id=1
Delete agenda by ID

## 🐛 Troubleshooting

### Database Connection Error
1. Check database credentials di `api/config.php`
2. Pastikan database dan user sudah dibuat
3. Pastikan user memiliki privileges ke database
4. Test connection dengan `test_connection.php`

### 404 Not Found
1. Pastikan file `.htaccess` ada (jika menggunakan pretty URLs)
2. Check file permissions
3. Pastikan folder structure benar

### CORS Issues
1. CORS headers sudah di-set di `api/config.php`
2. Pastikan API dipanggil dari domain yang sama
3. Check browser console untuk error details

### Performance Issues
1. Enable gzip compression di cPanel
2. Optimize images
3. Enable browser caching
4. Monitor error logs

## 📊 Sample Data

Database sudah include sample data:
- Hari Dokter Indonesia (24 Oktober)
- Hari Penerbangan Nasional (27 Oktober)
- Hari Sumpah Pemuda (28 Oktober)
- Hari Pahlawan (10 November)
- Hari Ibu (22 Desember)

## 🔒 Security Features

1. **Input Sanitization** - Semua input di-sanitize
2. **SQL Injection Protection** - Menggunakan prepared statements
3. **XSS Protection** - Output escaping dan security headers
4. **Rate Limiting** - Mencegah brute force attacks
5. **Error Handling** - Generic error messages untuk production
6. **CORS Configuration** - Proper CORS headers

## 🚀 Performance Optimization

1. **Debounced Search** - 300ms delay untuk search
2. **Lazy Loading** - Load data saat dibutuhkan
3. **Efficient DOM Updates** - Minimal reflows/repaints
4. **Compressed Assets** - CSS dan JS optimized
5. **Caching Headers** - Proper cache control

## 📞 Support

Jika mengalami masalah:
1. Check browser console untuk JavaScript errors
2. Check error logs di `logs/error.log`
3. Test API endpoints secara manual
4. Verify database connection
5. Check file permissions

## 🔄 Updates

Untuk update sistem:
1. Backup database dan files
2. Upload new files
3. Run database migrations jika ada
4. Test semua functionality
5. Monitor error logs

---

**Version**: 1.0.0  
**Last Updated**: 2024  
**Compatible**: PHP 7.4+, MySQL 5.7+, Modern Browsers  
**License**: MIT

🎉 **Selamat menggunakan Ngadimin Panel!**