-- Database Queen Florist Agenda
-- Created for XAMPP MySQL

-- Create database if not exists
CREATE DATABASE IF NOT EXISTS queen_florist DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Use the database
USE queen_florist;

-- Create agenda table
CREATE TABLE IF NOT EXISTS agenda (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month INT NOT NULL COMMENT 'Bulan (1-12)',
    day INT NOT NULL COMMENT 'Tanggal (1-31)',
    title VARCHAR(255) NOT NULL COMMENT 'Judul agenda',
    description TEXT COMMENT 'Deskripsi agenda',
    is_active TINYINT(1) DEFAULT 1 COMMENT 'Status aktif (1=aktif, 0=non-aktif)',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'Waktu dibuat',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Waktu diupdate',
    UNIQUE KEY unique_month_day (month, day),
    INDEX idx_month (month),
    INDEX idx_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Tabel agenda Queen Florist';

-- Insert default agenda data
INSERT INTO agenda (month, day, title, description) VALUES
-- September (month 9)
(9, 24, 'Hari Dokter Indonesia', 'Peringatan untuk tenaga medis Indonesia'),
(9, 27, 'Hari Penerbangan Nasional', 'Memperingati sejarah penerbangan Indonesia'),
(9, 28, 'Hari Sumpah Pemuda', 'Memperingati ikrar pemuda Indonesia 1928'),
(9, 30, 'Hari Keuangan', 'Hari kesadaran pentingnya literasi keuangan'),

-- October (month 10)
(10, 1, 'Hari Kesaktian Pancasila', 'Memperingati jasa Pahlawan Revolusi'),
(10, 10, 'Hari Kesehatan Jiwa', 'Meningkatkan kesadaran kesehatan mental'),
(10, 16, 'Hari Pangan Sedunia', 'Meningkatkan kesadaran akan masalah pangan'),
(10, 24, 'Hari Dokter Indonesia', 'Menghormati jasa para dokter'),
(10, 28, 'Hari Sumpah Pemuda', 'Memperingati ikrar pemuda Indonesia'),
(10, 29, 'Hari Stroke Nasional', 'Meningkatkan kesadaran pencegahan stroke'),

-- November (month 11)
(11, 10, 'Hari Pahlawan', 'Memperingati jasa pahlawan kemerdekaan'),
(11, 25, 'Hari Guru Nasional', 'Menghormati jasa para guru'),

-- December (month 12)
(12, 22, 'Hari Ibu', 'Memperingati jasa dan perjuangan ibu Indonesia'),

-- January (month 1)
(1, 1, 'Tahun Baru Masehi', 'Perayaan tahun baru 2025'),
(1, 25, 'Hari Gizi Nasional', 'Meningkatkan kesadaran akan pentingnya gizi'),

-- February (month 2)
(2, 14, 'Hari Valentine', 'Hari kasih sayang sedunia'),
(2, 21, 'Hari Kartini', 'Memperingati jasa RA Kartini'),

-- March (month 3)
(3, 8, 'Hari Perempuan Internasional', 'Meningkatkan kesadaran akan hak perempuan'),
(3, 21, 'Hari Down Syndrome', 'Meningkatkan kesadaran akan Down Syndrome'),
(3, 22, 'Hari Air Sedunia', 'Meningkatkan kesadaran akan pentingnya air'),

-- April (month 4)
(4, 7, 'Hari Kesehatan Internasional', 'Meningkatkan kesadaran kesehatan global'),
(4, 21, 'Hari Kartini', 'Memperingati jasa RA Kartini'),
(4, 22, 'Hari Bumi', 'Meningkatkan kesadaran lingkungan'),

-- May (month 5)
(5, 1, 'Hari Buruh Internasional', 'Memperingati perjuangan buruh'),
(5, 2, 'Hari Pendidikan Nasional', 'Memperingati ki Hajar Dewantara'),
(5, 20, 'Hari Kebangkitan Nasional', 'Memperingati kebangkitan nasional 1908'),

-- June (month 6)
(6, 1, 'Hari Lahir Pancasila', 'Memperingati lahirnya Pancasila'),
(6, 5, 'Hari Lingkungan Hidup Sedunia', 'Meningkatkan kesadaran lingkungan'),
(6, 29, 'Hari Keluarga Nasional', 'Meningkatkan kesadaran akan pentingnya keluarga'),

-- July (month 7)
(7, 1, 'Hari Bhayangkara', 'Hari ulang tahun Polri'),
(7, 22, 'Hari Anak Nasional', 'Meningkatkan kesadaran akan hak anak'),

-- August (month 8)
(8, 17, 'Hari Kemerdekaan RI', 'Memperingati kemerdekaan Indonesia');

-- Create admin user table for authentication
CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100),
    full_name VARCHAR(100),
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default admin user (password: admin123)
INSERT INTO admin_users (username, password, email, full_name) VALUES 
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@queenflorist.com', 'Administrator');

-- Create API logs table for monitoring
CREATE TABLE IF NOT EXISTS api_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    endpoint VARCHAR(255) NOT NULL,
    method VARCHAR(10) NOT NULL,
    request_data TEXT,
    response_code INT,
    ip_address VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_endpoint (endpoint),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create view for active agenda
CREATE VIEW active_agenda AS
SELECT 
    id,
    month,
    day,
    title,
    description,
    created_at,
    updated_at
FROM agenda 
WHERE is_active = 1 
ORDER BY month, day;

-- Sample queries for testing:

-- Get all agendas
-- SELECT * FROM agenda ORDER BY month, day;

-- Get agenda by month
-- SELECT * FROM agenda WHERE month = 10 ORDER BY day;

-- Get current month agenda
-- SELECT * FROM agenda WHERE month = MONTH(CURDATE()) ORDER BY day;

-- Add new agenda
-- INSERT INTO agenda (month, day, title, description) VALUES (12, 25, 'Hari Natal', 'Perayaan Natal 2025');

-- Update agenda
-- UPDATE agenda SET title = 'Judul Baru', description = 'Deskripsi baru' WHERE id = 1;

-- Delete agenda (soft delete)
-- UPDATE agenda SET is_active = 0 WHERE id = 1;

-- Hard delete
-- DELETE FROM agenda WHERE id = 1;

-- Search agenda
-- SELECT * FROM agenda WHERE title LIKE '%Hari%' OR description LIKE '%Hari%' ORDER BY month, day;