<?php
// Database Configuration
class Database {
    private $host = 'localhost';
    private $username = 'root';
    private $password = 'pwtkbm30S!';
    private $database = 'queenflo_agenda';
    private $conn;
    
    public function __construct() {
        $this->connect();
    }
    
    private function connect() {
        try {
            $this->conn = new mysqli(
                $this->host, 
                $this->username, 
                $this->password, 
                $this->database
            );
            
            if ($this->conn->connect_error) {
                throw new Exception("Connection failed: " . $this->conn->connect_error);
            }
            
            $this->conn->set_charset("utf8mb4");
            
        } catch (Exception $e) {
            die("Database connection failed: " . $e->getMessage());
        }
    }
    
    public function getConnection() {
        return $this->conn;
    }
    
    public function query($sql) {
        return $this->conn->query($sql);
    }
    
    public function prepare($sql) {
        return $this->conn->prepare($sql);
    }
    
    public function escape($string) {
        return $this->conn->real_escape_string($string);
    }
    
    public function getLastInsertId() {
        return $this->conn->insert_id;
    }
    
    public function close() {
        if ($this->conn) {
            $this->conn->close();
        }
    }
}

// CORS Headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Utility Functions
function sendResponse($data, $statusCode = 200) {
    http_response_code($statusCode);
    echo json_encode($data);
    exit();
}

function sendError($message, $statusCode = 400) {
    http_response_code($statusCode);
    echo json_encode([
        'success' => false,
        'message' => $message
    ]);
    exit();
}

function getRequestBody() {
    $input = file_get_contents('php://input');
    return json_decode($input, true);
}

function validateToken() {
    $headers = getallheaders();
    $authHeader = $headers['Authorization'] ?? '';
    
    if (strpos($authHeader, 'Bearer ') !== 0) {
        sendError('Unauthorized', 401);
    }
    
    $token = substr($authHeader, 7);
    
    // Simple token validation (in production, use JWT or similar)
    if (strpos($token, 'dummy-token-') !== 0) {
        sendError('Invalid token', 401);
    }
    
    return true;
}

function logApiCall($endpoint, $method, $requestData = null, $responseCode = 200) {
    $db = new Database();
    $conn = $db->getConnection();
    
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $requestDataJson = $requestData ? json_encode($requestData) : null;
    
    $stmt = $conn->prepare("
        INSERT INTO api_logs (endpoint, method, request_data, response_code, ip_address, user_agent) 
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->bind_param("sssiss", $endpoint, $method, $requestDataJson, $responseCode, $ip, $userAgent);
    $stmt->execute();
    $stmt->close();
}
?>