<?php
require_once 'config.php';

$database = new Database();
$conn = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    handleLogin();
} else {
    sendError('Method not allowed', 405);
}

function handleLogin() {
    global $conn;
    
    $data = getRequestBody();
    
    if (!isset($data['username']) || !isset($data['password'])) {
        sendError('Username and password are required');
    }
    
    $username = trim($data['username']);
    $password = $data['password'];
    
    if (empty($username) || empty($password)) {
        sendError('Username and password cannot be empty');
    }
    
    // Get user from database
    $stmt = $conn->prepare("
        SELECT id, username, password, email, full_name, is_active 
        FROM admin_users 
        WHERE username = ? AND is_active = 1
    ");
    
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        $stmt->close();
        sendError('Invalid username or password', 401);
    }
    
    $user = $result->fetch_assoc();
    $stmt->close();
    
    // Verify password (using password_verify for hashed passwords)
    if (password_verify($password, $user['password'])) {
        // Generate token (simple token for demo, use JWT in production)
        $token = 'queen-florist-token-' . time() . '-' . $user['id'];
        
        // Update last login
        $updateStmt = $conn->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?");
        $updateStmt->bind_param("i", $user['id']);
        $updateStmt->execute();
        $updateStmt->close();
        
        logApiCall('/auth/login', 'POST', ['username' => $username], 200);
        
        sendResponse([
            'success' => true,
            'message' => 'Login successful',
            'data' => [
                'token' => $token,
                'user' => [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'email' => $user['email'],
                    'full_name' => $user['full_name']
                ]
            ]
        ]);
    } else {
        logApiCall('/auth/login', 'POST', ['username' => $username], 401);
        sendError('Invalid username or password', 401);
    }
}

$conn->close();
?>