-- Database Setup for Schedule Management System
-- Run this script in your MySQL database to create the necessary table

-- Create database if not exists (optional)
-- CREATE DATABASE IF NOT EXISTS queen_florist;
-- USE queen_florist;

-- Create agenda table
CREATE TABLE IF NOT EXISTS agenda (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month INT NOT NULL COMMENT 'Month (1-12)',
    day INT NOT NULL COMMENT 'Day of month (1-31)',
    title VARCHAR(255) NOT NULL COMMENT 'Event title',
    description TEXT NOT NULL COMMENT 'Event description',
    is_active TINYINT(1) DEFAULT 1 COMMENT '1 for active, 0 for inactive',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation timestamp',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last update timestamp',
    
    -- Add constraints
    CONSTRAINT chk_month CHECK (month BETWEEN 1 AND 12),
    CONSTRAINT chk_day CHECK (day BETWEEN 1 AND 31),
    CONSTRAINT chk_is_active CHECK (is_active IN (0, 1))
);

-- Create indexes for better performance
CREATE INDEX idx_month_day ON agenda(month, day);
CREATE INDEX idx_is_active ON agenda(is_active);
CREATE INDEX idx_created_at ON agenda(created_at);

-- Insert sample data (optional - you can remove this if you have existing data)
INSERT INTO agenda (month, day, title, description, is_active) VALUES
(10, 24, 'Hari Dokter Indonesia', 'Peringatan hari dokter Indonesia untuk menghormati jasa para dokter', 1),
(10, 27, 'Hari Penerbangan Nasional', 'Peringatan hari penerbangan nasional Indonesia', 1),
(10, 28, 'Hari Sumpah Pemuda', 'Peringatan Sumpah Pemuda yang bersejarah bagi bangsa Indonesia', 1);

-- Create a user for the application (optional - for security)
-- CREATE USER IF NOT EXISTS 'queen_florist_user'@'localhost' IDENTIFIED BY 'your_secure_password';
-- GRANT SELECT, INSERT, UPDATE, DELETE ON queen_florist.agenda TO 'queen_florist_user'@'localhost';
-- FLUSH PRIVILEGES;

-- Display the created table structure
DESCRIBE agenda;

-- Show sample data
SELECT * FROM agenda ORDER BY month, day, id;