<?php
// Test database connection
// Access this file at: http://localhost/ngadimin/test_connection.php

echo "<h1>Database Connection Test</h1>";

// Database configuration
$host = 'localhost';
$dbname = 'queen_florist';
$user = 'root';
$pass = '';

try {
    // Test connection
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
    
    // Test if agenda table exists
    $stmt = $conn->prepare("SHOW TABLES LIKE 'agenda'");
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo "<p style='color: green;'>✅ Table 'agenda' exists!</p>";
        
        // Count records
        $stmt = $conn->prepare("SELECT COUNT(*) as count FROM agenda");
        $stmt->execute();
        $count = $stmt->fetch()['count'];
        
        echo "<p>📊 Total agenda in database: <strong>$count</strong></p>";
        
        // Show sample data
        if ($count > 0) {
            $stmt = $conn->prepare("SELECT * FROM agenda ORDER BY month, day LIMIT 5");
            $stmt->execute();
            $schedules = $stmt->fetchAll();
            
            echo "<h3>Sample Data:</h3>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>ID</th><th>Month</th><th>Day</th><th>Title</th><th>Status</th></tr>";
            
            foreach ($schedules as $agenda) {
                echo "<tr>";
                echo "<td>{$agenda['id']}</td>";
                echo "<td>{$agenda['month']}</td>";
                echo "<td>{$agenda['day']}</td>";
                echo "<td>{$agenda['title']}</td>";
                echo "<td>" . ($agenda['is_active'] ? 'Active' : 'Inactive') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
    } else {
        echo "<p style='color: orange;'>⚠️ Table 'agenda' does not exist!</p>";
        echo "<p>Please run the SQL setup script or import the database_setup.sql file.</p>";
    }
    
    // Test API endpoint
    echo "<h3>API Test:</h3>";
    $api_url = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $api_url = str_replace('test_connection.php', 'api/agenda.php', $api_url);
    
    echo "<p>Testing API endpoint: <code>$api_url</code></p>";
    
    $context = stream_context_create([
        'http' => [
            'timeout' => 5,
            'method' => 'GET',
            'header' => "Content-Type: application/json\r\n"
        ]
    ]);
    
    $response = @file_get_contents($api_url, false, $context);
    
    if ($response !== false) {
        echo "<p style='color: green;'>✅ API endpoint responding!</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
    } else {
        echo "<p style='color: red;'>❌ API endpoint not responding!</p>";
        echo "<p>Check if the API files exist and are properly configured.</p>";
    }
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Database connection failed!</p>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<h3>Troubleshooting:</h3>";
    echo "<ul>";
    echo "<li>Make sure XAMPP MySQL service is running</li>";
    echo "<li>Check database name: 'queen_florist'</li>";
    echo "<li>Check MySQL username: 'root'</li>";
    echo "<li>Check MySQL password (empty by default)</li>";
    echo "<li>Make sure the database exists in phpMyAdmin</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p><a href='index.html'>← Back to Admin Panel</a></p>";
?>