# Admin Panel Agenda Kegiatan

Admin panel responsif untuk mengelola agenda kegiatan dengan database MySQL. Dibuat dengan HTML5, CSS3, JavaScript, dan PHP.

## Fitur

- ✅ **CRUD Operations** - Create, Read, Update, Delete agenda
- ✅ **Responsive Design** - Tampilan optimal di desktop, tablet, dan mobile
- ✅ **Real-time Search** - Pencarian judul dan deskripsi
- ✅ **Filtering** - Filter berdasarkan bulan dan status
- ✅ **Statistics Dashboard** - Menampilkan total kegiatan, aktif, dan akan datang
- ✅ **Modern UI** - Desain modern dengan gradient dan animasi
- ✅ **Form Validation** - Validasi input di client dan server side
- ✅ **Toast Notifications** - Notifikasi untuk setiap aksi
- ✅ **Keyboard Shortcuts** - Shortcut untuk aksi cepat
- ✅ **Auto-refresh** - Refresh otomatis setiap 5 menit

## Persyaratan Sistem

- **XAMPP** (Apache, MySQL, PHP)
- **PHP 7.4+** dengan ekstensi PDO dan PDO MySQL
- **MySQL 5.7+** atau MariaDB 10.2+
- **Modern Web Browser** (Chrome, Firefox, Safari, Edge)

## Instalasi

### 1. Setup Database

1. Buka XAMPP Control Panel dan start Apache & MySQL
2. Buka phpMyAdmin (http://localhost/phpmyadmin)
3. Buat database dengan nama `queen_florist`
4. Import file `database_setup.sql` atau jalankan query berikut:

```sql
CREATE TABLE agenda (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month INT NOT NULL,
    day INT NOT NULL,
    title VARCHAR(255) NOT NULL,
    description TEXT NOT NULL,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

### 2. Deploy ke XAMPP

1. Copy folder `ngadimin` ke `C:/xampp/htdocs/` (Windows) atau `/opt/lampp/htdocs/` (Linux)
2. Pastikan struktur folder sebagai berikut:
```
htdocs/
└── ngadimin/
    ├── index.html
    ├── style.css
    ├── script.js
    ├── api/
    │   ├── config.php
    │   └── agenda.php
    ├── database_setup.sql
    └── README.md
```

### 3. Konfigurasi Database

Edit file `api/config.php` jika perlu mengubah koneksi database:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'queen_florist');
define('DB_USER', 'root');
define('DB_PASS', ''); // Kosongkan jika tidak ada password
```

### 4. Akses Aplikasi

Buka browser dan akses: `http://localhost/ngadimin/`

## Struktur Database

### Tabel `agenda`

| Kolom | Tipe | Deskripsi |
|-------|------|-----------|
| id | INT AUTO_INCREMENT | Primary key |
| month | INT | Bulan (1-12) |
| day | INT | Hari (1-31) |
| title | VARCHAR(255) | Judul kegiatan |
| description | TEXT | Deskripsi kegiatan |
| is_active | TINYINT(1) | Status aktif (1=aktif, 0=tidak aktif) |
| created_at | TIMESTAMP | Waktu pembuatan |
| updated_at | TIMESTAMP | Waktu update terakhir |

## API Endpoints

### GET `/api/agenda.php`
- Mengambil semua agenda
- Response: `{"success": true, "data": [...]}`

### GET `/api/agenda.php?id={id}`
- Mengambil agenda spesifik
- Response: `{"success": true, "data": {...}}`

### POST `/api/agenda.php`
- Menambah agenda baru
- Body: `{"month": 10, "day": 24, "title": "Judul", "description": "Deskripsi", "is_active": 1}`

### PUT `/api/agenda.php?id={id}`
- Update agenda
- Body: Sama seperti POST

### DELETE `/api/agenda.php?id={id}`
- Hapus agenda
- Response: `{"success": true, "message": "Agenda deleted successfully"}`

## Keyboard Shortcuts

- **Ctrl/Cmd + N** - Tambah agenda baru
- **Ctrl/Cmd + F** - Fokus ke search
- **Ctrl/Cmd + E** - Export ke CSV
- **Ctrl/Cmd + P** - Print
- **ESC** - Tutup modal

## Fitur Responsive

### Desktop (>768px)
- Layout 3 kolom untuk statistik
- Table dengan scroll horizontal
- Modal dengan ukuran normal

### Tablet (768px-480px)
- Layout 1 kolom untuk statistik
- Filter vertikal
- Modal responsive

### Mobile (<480px)
- Font size lebih kecil
- Button compact
- Toast notification full width

## Troubleshooting

### Error "Database connection failed"
- Pastikan MySQL sudah running di XAMPP
- Cek koneksi database di `api/config.php`
- Pastikan database `queen_florist` sudah ada

### Error "404 Not Found"
- Pastikan file berada di folder `htdocs/ngadimin/`
- Cek URL: `http://localhost/ngadimin/`

### Error "500 Internal Server Error"
- Cek error log Apache di `xampp/apache/logs/error.log`
- Pastikan PHP ekstensi PDO dan PDO MySQL aktif

### CORS Error
- Pastikan API endpoint menggunakan path relatif (`api/agenda.php`)
- Cek header CORS di `api/config.php`

## Security Features

- **Input Sanitization** - Semua input di-sanitize
- **SQL Injection Protection** - Menggunakan prepared statements
- **XSS Protection** - Output escaping
- **CORS Headers** - Cross-origin request handling
- **Input Validation** - Validasi client dan server side

## Customization

### Mengubah Warna Theme
Edit file `style.css` dan ubah CSS variables:
```css
:root {
    --primary-color: #667eea;
    --secondary-color: #764ba2;
}
```

### Menambah Field Baru
1. Tambah kolom di database
2. Update API di `agenda.php`
3. Tambah field di form HTML
4. Update JavaScript untuk handle field baru

### Mengubah Bahasa
Edit string di:
- `index.html` untuk label dan judul
- `script.js` untuk pesan JavaScript
- `agenda.php` untuk pesan API

## Performance Optimization

- **Indexing** - Database index untuk month, day, is_active
- **Lazy Loading** - Load data saat dibutuhkan
- **Caching** - Browser caching untuk static assets
- **Minification** - CSS dan JavaScript sudah optimized

## Support

Jika mengalami masalah:
1. Cek browser console untuk JavaScript errors
2. Cek Apache error log
3. Pastikan semua file sudah terupload dengan benar
4. Test API endpoint langsung di browser

## License

Project ini dapat digunakan dan dimodifikasi secara bebas.