# Admin Panel Agenda Kegiatan - NeoQueen

Admin panel responsif untuk mengelola agenda kegiatan dengan database MySQL. Dibuat dengan HTML5, CSS3, JavaScript, dan PHP.

## 🌐 Access URL

**Live URL**: `http://localhost/neoqueen/ngadimin/`

## 📁 Folder Structure

```
htdocs/
└── neoqueen/
    └── ngadimin/
        ├── index.html          # Halaman utama admin panel
        ├── style.css           # Styling responsif dengan modern design
        ├── script.js           # JavaScript untuk CRUD operations
        ├── api/
        │   ├── config.php      # Konfigurasi database
        │   └── agenda.php      # API endpoints
        ├── database_setup.sql  # SQL script untuk setup database
        ├── test_connection.php # File testing koneksi database
        ├── .htaccess          # Security & performance settings
        └── README.md          # Dokumentasi ini
```

## ✨ Fitur Utama

- ✅ **CRUD Operations** - Create, Read, Update, Delete agenda
- ✅ **Responsive Design** - Tampilan optimal di desktop, tablet, dan mobile
- ✅ **Real-time Search** - Pencarian judul dan deskripsi
- ✅ **Filtering** - Filter berdasarkan bulan dan status
- ✅ **Statistics Dashboard** - Menampilkan total agenda, aktif, dan akan datang
- ✅ **Modern UI** - Desain modern dengan gradient dan animasi
- ✅ **Form Validation** - Validasi input di client dan server side
- ✅ **Toast Notifications** - Notifikasi untuk setiap aksi
- ✅ **Keyboard Shortcuts** - Shortcut untuk aksi cepat
- ✅ **Auto-refresh** - Refresh otomatis setiap 5 menit

## 🚀 Cara Deploy ke XAMPP

### 1. Copy Files ke XAMPP

Copy folder `neoqueen/ngadimin` ke dalam folder XAMPP:
- **Windows**: `C:/xampp/htdocs/`
- **Linux**: `/opt/lampp/htdocs/`

### 2. Setup Database

1. Buka XAMPP Control Panel dan start Apache & MySQL
2. Buka phpMyAdmin (http://localhost/phpmyadmin)
3. Buat database dengan nama `queen_florist`
4. Import file `database_setup.sql` atau jalankan query manual

### 3. Test Koneksi

Buka browser dan akses: `http://localhost/neoqueen/ngadimin/test_connection.php`

### 4. Akses Aplikasi

Buka browser dan akses: `http://localhost/neoqueen/ngadimin/`

## 🗄️ Konfigurasi Database

**Database Settings** (di `api/config.php`):
- **DB_HOST**: localhost
- **DB_NAME**: queen_florist
- **DB_USER**: root
- **DB_PASS**: (kosong)

### Tabel `agenda`

| Kolom | Tipe | Deskripsi |
|-------|------|-----------|
| id | INT AUTO_INCREMENT | Primary key |
| month | INT | Bulan (1-12) |
| day | INT | Hari (1-31) |
| title | VARCHAR(255) | Judul kegiatan |
| description | TEXT | Deskripsi kegiatan |
| is_active | TINYINT(1) | Status aktif (1=aktif, 0=tidak aktif) |
| created_at | TIMESTAMP | Waktu pembuatan |
| updated_at | TIMESTAMP | Waktu update terakhir |

## 🔌 API Endpoints

### GET `/api/agenda.php`
- Mengambil semua agenda
- Response: `{"success": true, "data": [...]}`

### GET `/api/agenda.php?id={id}`
- Mengambil agenda spesifik
- Response: `{"success": true, "data": {...}}`

### POST `/api/agenda.php`
- Menambah agenda baru
- Body: `{"month": 10, "day": 24, "title": "Judul", "description": "Deskripsi", "is_active": 1}`

### PUT `/api/agenda.php?id={id}`
- Update agenda
- Body: Sama seperti POST

### DELETE `/api/agenda.php?id={id}`
- Hapus agenda
- Response: `{"success": true, "message": "Agenda deleted successfully"}`

## ⌨️ Keyboard Shortcuts

- **Ctrl/Cmd + N** - Tambah agenda baru
- **Ctrl/Cmd + F** - Fokus ke search
- **Ctrl/Cmd + E** - Export ke CSV
- **Ctrl/Cmd + P** - Print
- **ESC** - Tutup modal

## 📱 Responsive Breakpoints

### Desktop (>768px)
- Layout 3 kolom untuk statistik
- Table dengan scroll horizontal
- Modal dengan ukuran normal

### Tablet (768px-480px)
- Layout 1 kolom untuk statistik
- Filter vertikal
- Modal responsive

### Mobile (<480px)
- Font size lebih kecil
- Button compact
- Toast notification full width

## 🛠️ Troubleshooting

### Error "Database connection failed"
- Pastikan MySQL sudah running di XAMPP
- Cek koneksi database di `api/config.php`
- Pastikan database `queen_florist` sudah ada

### Error "404 Not Found"
- Pastikan file berada di folder `htdocs/neoqueen/ngadimin/`
- Cek URL: `http://localhost/neoqueen/ngadimin/`

### Error "500 Internal Server Error"
- Cek error log Apache di `xampp/apache/logs/error.log`
- Pastikan PHP ekstensi PDO dan PDO MySQL aktif

### CORS Error
- Pastikan API endpoint menggunakan path relatif (`api/agenda.php`)
- Cek header CORS di `api/config.php`

## 🔒 Security Features

- **Input Sanitization** - Semua input di-sanitize
- **SQL Injection Protection** - Menggunakan prepared statements
- **XSS Protection** - Output escaping
- **CORS Headers** - Cross-origin request handling
- **Input Validation** - Validasi client dan server side
- **Security Headers** - HTTP security headers via .htaccess

## 🎨 Customization

### Mengubah Warna Theme
Edit file `style.css` dan ubah CSS variables:
```css
:root {
    --primary-color: #667eea;
    --secondary-color: #764ba2;
}
```

### Menambah Field Baru
1. Tambah kolom di database
2. Update API di `api/agenda.php`
3. Tambah field di form HTML
4. Update JavaScript untuk handle field baru

### Mengubah Bahasa
Edit string di:
- `index.html` untuk label dan judul
- `script.js` untuk pesan JavaScript
- `api/agenda.php` untuk pesan API

## 📈 Performance Optimization

- **Indexing** - Database index untuk month, day, is_active
- **Lazy Loading** - Load data saat dibutuhkan
- **Caching** - Browser caching untuk static assets
- **Compression** - Gzip compression via .htaccess
- **Minification** - CSS dan JavaScript sudah optimized

## 🧪 Testing

### Test Database Connection
Akses: `http://localhost/neoqueen/ngadimin/test_connection.php`

### Test API Endpoints
```bash
# Get all agenda
curl http://localhost/neoqueen/ngadimin/api/agenda.php

# Get specific agenda
curl http://localhost/neoqueen/ngadimin/api/agenda.php?id=1

# Create new agenda
curl -X POST http://localhost/neoqueen/ngadimin/api/agenda.php \
  -H "Content-Type: application/json" \
  -d '{"month":12,"day":25,"title":"Test","description":"Test agenda","is_active":1}'
```

## 📞 Support

Jika mengalami masalah:
1. Cek browser console untuk JavaScript errors
2. Cek Apache error log
3. Pastikan semua file sudah terupload dengan benar
4. Test API endpoint langsung di browser
5. Jalankan test_connection.php untuk debugging

## 📄 License

Project ini dapat digunakan dan dimodifikasi secara bebas.

---

**Admin Panel Agenda Kegiatan - NeoQueen Version**  
*Powered by HTML5, CSS3, JavaScript, PHP & MySQL*