# 🌸 Queen Florist - Landing Page HTML5

Landing page modern dan responsif untuk Queen Florist yang siap deploy di XAMPP.

## 📁 Struktur Folder

```
queen-florist-xampp/
├── index.html          # Halaman utama
├── style.css           # Stylesheet lengkap
├── script.js           # JavaScript functionality
└── README.md           # Instruksi ini
```

## 🚀 Cara Deploy ke XAMPP

### 1. Install XAMPP
- Download dan install XAMPP dari [https://www.apachefriends.org](https://www.apachefriends.org)
- Pastikan Apache dan MySQL sudah terinstall

### 2. Copy Files ke htdocs
- Buka folder instalasi XAMPP (biasanya `C:/xampp/` atau `/opt/lampp/`)
- Masuk ke folder `htdocs`
- Buat folder baru bernama `queen-florist`
- Copy semua file dari folder `queen-florist-xampp` ke `htdocs/queen-florist`

### 3. Start Apache
- Buka XAMPP Control Panel
- Start Apache server
- Pastikan status Apache berwarna hijau

### 4. Akses Website
- Buka browser
- Kunjungi `http://localhost/queen-florist`
- Website akan langsung berjalan tanpa perlu setup database

## 🌟 Fitur yang Tersedia

### ✅ Header & Navigasi
- Fixed header dengan smooth scroll
- Mobile responsive menu
- Logo Queen Florist dengan animasi

### ✅ Hero Section
- Background image dari URL yang diminta
- Judul "Temukan Bunga Terindah untuk Setiap Momen"
- CTA buttons untuk lihat produk dan chat admin

### ✅ Agenda Bulanan
- Sistem otomatis berdasarkan bulan berjalan
- Menampilkan agenda spesial bulan ini
- Responsive card design

### ✅ Katalog Produk (10 Kategori)
1. Standing Flower
2. Paper Flower
3. Duka Cita
4. Bouquet
5. Wedding Car Decoration
6. Balloon Decoration
7. Kado Rustic
8. Balloon Parcel
9. Snack Bouquet
10. Tart Snack

### ✅ WhatsApp Integration
- Chat langsung dengan admin
- Form pemesanan lengkap
- Link gambar otomatis terkirim
- Copy link gambar functionality

### ✅ Testimoni Pelanggan
- 3 testimoni dengan rating 5 bintang
- Responsive card layout

### ✅ Footer Lengkap
- Informasi kontak lengkap
- Link media sosial
- Copyright notice

## 📱 Responsive Design

### Mobile (< 768px)
- Hamburger menu
- Single column layout
- Touch-friendly buttons
- Optimized images

### Tablet (768px - 1024px)
- 2-3 column grid
- Improved spacing
- Better touch targets

### Desktop (> 1024px)
- Multi-column layout
- Hover effects
- Smooth animations

## 🎨 Teknologi yang Digunakan

- **HTML5** - Semantic markup
- **CSS3** - Modern styling dengan Flexbox & Grid
- **JavaScript ES6+** - Modern JavaScript functionality
- **Font Awesome** - Icons library
- **Responsive Design** - Mobile-first approach

## 🔧 Konfigurasi Tambahan

### Virtual Host (Opsional)
Jika ingin menggunakan custom domain:

1. Edit `C:/xampp/apache/conf/extra/httpd-vhosts.conf`
2. Tambahkan:
```apache
<VirtualHost *:80>
    DocumentRoot "C:/xampp/htdocs/queen-florist"
    ServerName queenflorist.local
</VirtualHost>
```

3. Edit `C:/Windows/System32/drivers/etc/hosts`
4. Tambahkan: `127.0.0.1 queenflorist.local`

### HTTPS (Opsional)
Untuk HTTPS di localhost:
1. Gunakan XAMPP dengan SSL certificate
2. Atur Apache untuk HTTPS
3. Akses via `https://localhost/queen-florist`

## 🌐 Browser Support

- ✅ Chrome 60+
- ✅ Firefox 55+
- ✅ Safari 12+
- ✅ Edge 79+
- ✅ Opera 47+

## 📝 Customization

### Mengubah Gambar Hero
Edit file `style.css`:
```css
.hero {
    background: url('URL_GAMBAR_BARU') center/cover no-repeat;
}
```

### Mengubah Nomor WhatsApp
Edit file `script.js`:
```javascript
const phoneNumber = '6281223968122'; // Ganti dengan nomor baru
```

### Menambah Produk
Edit file `script.js` di array `productCategories`:
```javascript
{
    id: 11,
    name: "Nama Produk Baru",
    icon: "fas fa-icon",
    image: "URL_GAMBAR",
    description: "Deskripsi produk"
}
```

## 🚀 Performance Optimization

- ✅ Lazy loading untuk images
- ✅ Minified CSS & JS
- ✅ Optimized animations
- ✅ Efficient DOM manipulation
- ✅ Debounced scroll events

## 📊 SEO Features

- ✅ Meta tags lengkap
- ✅ Open Graph tags
- ✅ Semantic HTML5
- ✅ Alt text untuk images
- ✅ Responsive design

## 🔒 Security

- ✅ No database dependencies
- ✅ Safe WhatsApp integration
- ✅ Input validation
- ✅ XSS prevention

## 📞 Support

Jika ada masalah:
1. Pastikan Apache sudah running
2. Check browser console untuk error
3. Pastikan semua file sudah di-copy dengan benar
4. Clear browser cache

---

🌸 **Queen Florist** - Toko Bunga Terpercaya di Kebumen  
📍 Gg. Kutilang No.7, Panjer, Kebumen  
📞 +6281223968122