<?php
$page_title = 'Produk';
ob_start();
?>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <div class="page-header-left">
            <h2>Manajemen Produk</h2>
            <p>Kelola semua produk Queen Florist</p>
        </div>
        <div class="page-header-right">
            <a href="index.php?page=products_create" class="btn btn-primary">
                <i class="fas fa-plus"></i>
                Tambah Produk
            </a>
        </div>
    </div>
</div>

<!-- Search and Filter -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="search-form">
            <input type="hidden" name="page" value="products">
            <div class="search-row">
                <div class="search-input">
                    <i class="fas fa-search"></i>
                    <input 
                        type="text" 
                        name="search" 
                        placeholder="Cari produk..." 
                        value="<?php echo htmlspecialchars($search ?? ''); ?>"
                    >
                </div>
                <select name="category" class="form-select">
                    <option value="">Semua Kategori</option>
                    <?php foreach ($categories as $cat): ?>
                        <option value="<?php echo htmlspecialchars($cat); ?>" <?php echo ($category ?? '') === $cat ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($cat); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <button type="submit" class="btn btn-outline">Cari</button>
                <?php if (!empty($search) || !empty($category)): ?>
                    <a href="index.php?page=products" class="btn btn-outline">Reset</a>
                <?php endif; ?>
            </div>
        </form>
    </div>
</div>

<!-- Products Table -->
<div class="card">
    <div class="card-body">
        <?php if (empty($products)): ?>
            <div class="empty-state">
                <i class="fas fa-box"></i>
                <h3>Belum ada produk</h3>
                <p><?php echo !empty($search) || !empty($category) ? 'Tidak ada produk yang cocok dengan filter' : 'Mulai dengan menambah produk pertama'; ?></p>
                <?php if (empty($search) && empty($category)): ?>
                <a href="index.php?page=products_create" class="btn btn-primary">
                    <i class="fas fa-plus"></i>
                    Tambah Produk
                </a>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <form method="POST" action="index.php?page=products_bulk_delete" id="bulkForm">
                <div class="table-actions">
                    <div class="bulk-actions">
                        <label class="checkbox-label">
                            <input type="checkbox" id="selectAll">
                            <span>Pilih Semua</span>
                        </label>
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus produk yang dipilih?')">
                            <i class="fas fa-trash"></i>
                            Hapus Dipilih
                        </button>
                    </div>
                    <div class="table-info">
                        Menampilkan <?php echo count($products); ?> dari <?php echo $total; ?> produk
                    </div>
                </div>
                
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th width="40">
                                    <input type="checkbox" id="selectAllHeader">
                                </th>
                                <th width="80">Gambar</th>
                                <th>Nama Produk</th>
                                <th>Kategori</th>
                                <th>Harga</th>
                                <th>Status</th>
                                <th>Dibuat Oleh</th>
                                <th width="120">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($products as $product): ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="ids[]" value="<?php echo $product['id']; ?>" class="row-checkbox">
                                    </td>
                                    <td>
                                        <div class="product-image-thumb">
                                            <?php if (!empty($product['image_url'])): ?>
                                                <img src="<?php echo htmlspecialchars($product['image_url']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
                                            <?php else: ?>
                                                <div class="no-image-thumb">
                                                    <i class="fas fa-image"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <strong><?php echo htmlspecialchars($product['name']); ?></strong>
                                            <?php if ($product['is_best_seller']): ?>
                                                <span class="badge badge-warning">Best Seller</span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-info"><?php echo htmlspecialchars($product['category']); ?></span>
                                    </td>
                                    <td>
                                        <strong>Rp <?php echo number_format($product['price'], 0, ',', '.'); ?></strong>
                                    </td>
                                    <td>
                                        <?php if ($product['is_best_seller']): ?>
                                            <span class="badge badge-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Normal</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small><?php echo htmlspecialchars($product['created_by_name'] ?? 'System'); ?></small>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="index.php?page=products_view&id=<?php echo $product['id']; ?>" class="btn btn-sm btn-outline" title="Lihat">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="index.php?page=products_edit&id=<?php echo $product['id']; ?>" class="btn btn-sm btn-outline" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form method="POST" action="index.php?page=products_delete&id=<?php echo $product['id']; ?>" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus produk ini?')">
                                                <button type="submit" class="btn btn-sm btn-danger" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if ($totalPages > 1): ?>
                    <div class="pagination">
                        <?php if ($page > 1): ?>
                            <a href="?page=products&p=<?php echo $page - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?><?php echo !empty($category) ? '&category=' . urlencode($category) : ''; ?>" class="pagination-link">
                                <i class="fas fa-chevron-left"></i>
                            </a>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <?php if ($i == $page): ?>
                                <span class="pagination-link active"><?php echo $i; ?></span>
                            <?php else: ?>
                                <a href="?page=products&p=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?><?php echo !empty($category) ? '&category=' . urlencode($category) : ''; ?>" class="pagination-link">
                                    <?php echo $i; ?>
                                </a>
                            <?php endif; ?>
                        <?php endfor; ?>
                        
                        <?php if ($page < $totalPages): ?>
                            <a href="?page=products&p=<?php echo $page + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?><?php echo !empty($category) ? '&category=' . urlencode($category) : ''; ?>" class="pagination-link">
                                <i class="fas fa-chevron-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </form>
        <?php endif; ?>
    </div>
</div>

<style>
.product-image-thumb {
    width: 60px;
    height: 60px;
    border-radius: 8px;
    overflow: hidden;
    border: 1px solid #e5e7eb;
}

.product-image-thumb img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.no-image-thumb {
    width: 60px;
    height: 60px;
    background: #f3f4f6;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #9ca3af;
    border-radius: 8px;
    border: 1px solid #e5e7eb;
}

.btn-group {
    display: flex;
    gap: 0.25rem;
}

.form-select {
    padding: 0.5rem;
    border: 1px solid #d1d5db;
    border-radius: 0.375rem;
    background: white;
    min-width: 150px;
}
</style>

<script>
// Select all functionality
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.row-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

document.getElementById('selectAllHeader').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.row-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
    document.getElementById('selectAll').checked = this.checked;
});

// Update select all when individual checkboxes change
document.querySelectorAll('.row-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', function() {
        const allCheckboxes = document.querySelectorAll('.row-checkbox');
        const checkedCheckboxes = document.querySelectorAll('.row-checkbox:checked');
        document.getElementById('selectAll').checked = allCheckboxes.length === checkedCheckboxes.length;
        document.getElementById('selectAllHeader').checked = allCheckboxes.length === checkedCheckboxes.length;
    });
});
</script>

<?php
$content = ob_get_clean();
include __DIR__ . '/layout.php';
?>