<?php
$page_title = 'Tambah Produk';
ob_start();
?>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <div class="page-header-left">
            <h2>Tambah Produk Baru</h2>
            <p>Isi form di bawah untuk menambah produk baru</p>
        </div>
        <div class="page-header-right">
            <a href="index.php?page=products" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i>
                Kembali
            </a>
        </div>
    </div>
</div>

<!-- Form -->
<div class="card">
    <div class="card-body">
        <form method="POST" action="index.php?page=products_store" id="productForm" enctype="multipart/form-data">
            <div class="form-grid">
                <div class="form-group">
                    <label for="name">Nama Produk *</label>
                    <input 
                        type="text" 
                        id="name" 
                        name="name" 
                        required 
                        maxlength="255"
                        value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>"
                        placeholder="Masukkan nama produk"
                    >
                    <small class="form-help">Nama produk akan ditampilkan di katalog</small>
                </div>
                
                <div class="form-group">
                    <label for="category">Kategori *</label>
                    <select id="category" name="category" required>
                        <option value="">Pilih Kategori</option>
                        <?php 
                        $defaultCategories = ['Bunga Papan', 'Hand Bouquet', 'Bunga Meja', 'Bunga Krans', 'Box Flower', 'Standing Flower'];
                        foreach ($defaultCategories as $cat): 
                        ?>
                            <option value="<?php echo htmlspecialchars($cat); ?>" <?php echo (($_POST['category'] ?? '') === $cat) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($cat); ?>
                            </option>
                        <?php endforeach; ?>
                        <?php foreach ($categories as $cat): ?>
                            <?php if (!in_array($cat, $defaultCategories)): ?>
                                <option value="<?php echo htmlspecialchars($cat); ?>" <?php echo (($_POST['category'] ?? '') === $cat) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($cat); ?>
                                </option>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </select>
                    <small class="form-help">Pilih kategori yang sesuai untuk produk</small>
                </div>
                
                <div class="form-group">
                    <label for="price">Harga *</label>
                    <input 
                        type="number" 
                        id="price" 
                        name="price" 
                        required 
                        min="0"
                        step="1000"
                        value="<?php echo htmlspecialchars($_POST['price'] ?? ''); ?>"
                        placeholder="0"
                    >
                    <small class="form-help">Masukkan harga dalam Rupiah</small>
                </div>
                
                <div class="form-group">
                    <label for="icon">Icon (Opsional)</label>
                    <input 
                        type="text" 
                        id="icon" 
                        name="icon" 
                        maxlength="50"
                        value="<?php echo htmlspecialchars($_POST['icon'] ?? ''); ?>"
                        placeholder="fa-flower"
                    >
                    <small class="form-help">Nama icon FontAwesome (contoh: fa-flower)</small>
                </div>
                
                <div class="form-group full-width">
                    <label for="description">Deskripsi Produk *</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        required 
                        rows="6"
                        placeholder="Deskripsikan produk secara detail"
                    ><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
                    <small class="form-help">Jelaskan detail produk, bahan, ukuran, dan informasi penting lainnya</small>
                </div>
                
                <div class="form-group full-width">
                    <label for="image">Gambar Produk *</label>
                    <div class="image-upload-container">
                        <div class="image-preview" id="imagePreview">
                            <div class="upload-placeholder">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <p>Klik untuk upload gambar</p>
                                <small>Format: JPG, PNG, GIF, WebP (Maks: 5MB)</small>
                            </div>
                        </div>
                        <input 
                            type="file" 
                            id="image" 
                            name="image" 
                            accept="image/*"
                            required
                            style="display: none;"
                        >
                        <button type="button" class="btn btn-outline" id="uploadBtn">
                            <i class="fas fa-upload"></i>
                            Pilih Gambar
                        </button>
                        <button type="button" class="btn btn-danger" id="removeImageBtn" style="display: none;">
                            <i class="fas fa-trash"></i>
                            Hapus Gambar
                        </button>
                    </div>
                    <small class="form-help">Upload gambar produk dengan kualitas baik. Gambar akan ditampilkan di halaman utama.</small>
                </div>
                
                <div class="form-group full-width">
                    <label class="checkbox-label">
                        <input type="checkbox" name="is_best_seller" value="1" <?php echo isset($_POST['is_best_seller']) ? 'checked' : ''; ?>>
                        <span>Jadikan Best Seller</span>
                    </label>
                    <small class="form-help">Produk best seller akan ditampilkan di halaman utama</small>
                </div>
            </div>
            
            <div class="form-actions">
                <a href="index.php?page=products" class="btn btn-outline">
                    <i class="fas fa-times"></i>
                    Batal
                </a>
                <button type="submit" class="btn btn-primary" id="submitBtn">
                    <i class="fas fa-save"></i>
                    <span>Simpan Produk</span>
                </button>
            </div>
        </form>
    </div>
</div>

<style>
.image-upload-container {
    border: 2px dashed #d1d5db;
    border-radius: 8px;
    padding: 2rem;
    text-align: center;
    background: #f9fafb;
    transition: all 0.3s ease;
}

.image-upload-container:hover {
    border-color: #3b82f6;
    background: #eff6ff;
}

.image-preview {
    margin-bottom: 1rem;
    min-height: 200px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.image-preview img {
    max-width: 100%;
    max-height: 300px;
    border-radius: 8px;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.upload-placeholder {
    color: #6b7280;
}

.upload-placeholder i {
    font-size: 3rem;
    margin-bottom: 1rem;
    color: #9ca3af;
}

.upload-placeholder p {
    margin: 0.5rem 0;
    font-weight: 500;
}

.upload-placeholder small {
    color: #9ca3af;
}

.checkbox-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
}

.checkbox-label input[type="checkbox"] {
    width: auto;
}
</style>

<script>
// Image upload functionality
const imageInput = document.getElementById('image');
const imagePreview = document.getElementById('imagePreview');
const uploadBtn = document.getElementById('uploadBtn');
const removeImageBtn = document.getElementById('removeImageBtn');

uploadBtn.addEventListener('click', function() {
    imageInput.click();
});

removeImageBtn.addEventListener('click', function() {
    imageInput.value = '';
    imagePreview.innerHTML = `
        <div class="upload-placeholder">
            <i class="fas fa-cloud-upload-alt"></i>
            <p>Klik untuk upload gambar</p>
            <small>Format: JPG, PNG, GIF, WebP (Maks: 5MB)</small>
        </div>
    `;
    removeImageBtn.style.display = 'none';
    uploadBtn.style.display = 'inline-block';
});

imageInput.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        // Validate file type
        const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp'];
        if (!allowedTypes.includes(file.type)) {
            alert('Tipe file tidak diizinkan. Hanya JPG, PNG, GIF, dan WebP.');
            imageInput.value = '';
            return;
        }
        
        // Validate file size (5MB)
        if (file.size > 5 * 1024 * 1024) {
            alert('Ukuran file terlalu besar. Maksimal 5MB.');
            imageInput.value = '';
            return;
        }
        
        // Preview image
        const reader = new FileReader();
        reader.onload = function(e) {
            imagePreview.innerHTML = `<img src="${e.target.result}" alt="Preview">`;
            removeImageBtn.style.display = 'inline-block';
            uploadBtn.style.display = 'none';
        };
        reader.readAsDataURL(file);
    }
});

// Form submission
document.getElementById('productForm').addEventListener('submit', function(e) {
    const submitBtn = document.getElementById('submitBtn');
    const btnText = submitBtn.querySelector('span');
    
    // Show loading state
    submitBtn.disabled = true;
    btnText.textContent = 'Menyimpan...';
    
    // Re-enable after 5 seconds in case of network issues
    setTimeout(() => {
        submitBtn.disabled = false;
        btnText.textContent = 'Simpan Produk';
    }, 5000);
});

// Auto-save to localStorage
const form = document.getElementById('productForm');
const inputs = form.querySelectorAll('input, textarea, select');

// Load saved data
inputs.forEach(input => {
    if (input.type !== 'file') {
        const savedValue = localStorage.getItem('product_draft_' + input.name);
        if (savedValue && !input.value) {
            input.value = savedValue;
        }
    }
});

// Save to localStorage on input
inputs.forEach(input => {
    if (input.type !== 'file') {
        input.addEventListener('input', function() {
            localStorage.setItem('product_draft_' + this.name, this.value);
        });
    }
});

// Clear draft on successful submit
form.addEventListener('submit', function() {
    inputs.forEach(input => {
        if (input.type !== 'file') {
            localStorage.removeItem('product_draft_' + input.name);
        }
    });
});

// Price formatting
const priceInput = document.getElementById('price');
priceInput.addEventListener('blur', function() {
    if (this.value && !isNaN(this.value)) {
        this.value = parseInt(this.value);
    }
});
</script>

<?php
$content = ob_get_clean();
include __DIR__ . '/layout.php';
?>