<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Admin Panel'; ?> - Queen Florist Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="logo">
                    <span class="logo-icon">🌸</span>
                    <span class="logo-text">Queen Florist</span>
                </div>
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            
            <nav class="sidebar-nav">
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="index.php?page=dashboard" class="nav-link <?php echo ($_GET['page'] ?? '') === 'dashboard' ? 'active' : ''; ?>">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php?page=agenda" class="nav-link <?php echo ($_GET['page'] ?? '') === 'agenda' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-alt"></i>
                            <span>Agenda</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php?page=products" class="nav-link <?php echo ($_GET['page'] ?? '') === 'products' ? 'active' : ''; ?>">
                            <i class="fas fa-box"></i>
                            <span>Produk</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php?page=activity_logs" class="nav-link <?php echo ($_GET['page'] ?? '') === 'activity_logs' ? 'active' : ''; ?>">
                            <i class="fas fa-history"></i>
                            <span>Aktivitas</span>
                        </a>
                    </li>
                    <?php if ($_SESSION['admin_role'] === 'admin'): ?>
                    <li class="nav-item">
                        <a href="index.php?page=admin_management" class="nav-link <?php echo ($_GET['page'] ?? '') === 'admin_management' ? 'active' : ''; ?>">
                            <i class="fas fa-users-cog"></i>
                            <span>Admin</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <div class="nav-footer">
                    <div class="user-info">
                        <div class="user-avatar">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <div class="user-details">
                            <div class="user-name"><?php echo htmlspecialchars($_SESSION['admin_name']); ?></div>
                            <div class="user-role"><?php echo htmlspecialchars(ucfirst($_SESSION['admin_role'])); ?></div>
                        </div>
                    </div>
                    
                    <ul class="nav-list">
                        <li class="nav-item">
                            <a href="index.php?page=profile" class="nav-link">
                                <i class="fas fa-user"></i>
                                <span>Profil</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="index.php?page=change_password" class="nav-link">
                                <i class="fas fa-key"></i>
                                <span>Ubah Password</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="index.php?page=logout" class="nav-link logout">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Header -->
            <header class="header">
                <div class="header-left">
                    <button class="mobile-sidebar-toggle" id="mobileSidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="page-title"><?php echo $page_title ?? 'Admin Panel'; ?></h1>
                </div>
                <div class="header-right">
                    <div class="header-time" id="headerTime"></div>
                </div>
            </header>
            
            <!-- Content -->
            <div class="content">
                <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success">
                        <?php 
                        echo htmlspecialchars($_SESSION['success']);
                        unset($_SESSION['success']);
                        ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-error">
                        <?php 
                        echo htmlspecialchars($_SESSION['error']);
                        unset($_SESSION['error']);
                        ?>
                    </div>
                <?php endif; ?>
                
                <?php echo $content ?? ''; ?>
            </div>
        </main>
    </div>
    
    <script src="assets/js/admin.js"></script>
    <script>
        // Update header time
        function updateHeaderTime() {
            const now = new Date();
            const options = { 
                weekday: 'long', 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            };
            document.getElementById('headerTime').textContent = now.toLocaleDateString('id-ID', options);
        }
        
        updateHeaderTime();
        setInterval(updateHeaderTime, 60000); // Update every minute
    </script>
</body>
</html>