-- Queen Florist Admin Panel Database Schema
-- Generated for admin panel functionality

-- Create admin users table
CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    role ENUM('admin', 'editor') DEFAULT 'admin',
    is_active BOOLEAN DEFAULT TRUE,
    last_login DATETIME NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default admin user (password: admin123)
INSERT INTO admin_users (username, password, email, full_name, role) VALUES 
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@queenflorist.com', 'Administrator', 'admin');

-- Create activity log table
CREATE TABLE IF NOT EXISTS admin_activity_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    admin_id INT NOT NULL,
    action VARCHAR(100) NOT NULL,
    table_name VARCHAR(50) NULL,
    record_id INT NULL,
    description TEXT NULL,
    ip_address VARCHAR(45) NULL,
    user_agent TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (admin_id) REFERENCES admin_users(id) ON DELETE CASCADE
);

-- Update existing tables to add created_by and updated_by fields
ALTER TABLE products 
ADD COLUMN created_by INT NULL,
ADD COLUMN updated_by INT NULL,
ADD FOREIGN KEY (created_by) REFERENCES admin_users(id) ON DELETE SET NULL,
ADD FOREIGN KEY (updated_by) REFERENCES admin_users(id) ON DELETE SET NULL;

ALTER TABLE agenda 
ADD COLUMN created_by INT NULL,
ADD COLUMN updated_by INT NULL,
ADD FOREIGN KEY (created_by) REFERENCES admin_users(id) ON DELETE SET NULL,
ADD FOREIGN KEY (updated_by) REFERENCES admin_users(id) ON DELETE SET NULL;

-- Create indexes for better performance
CREATE INDEX idx_admin_users_username ON admin_users(username);
CREATE INDEX idx_admin_users_email ON admin_users(email);
CREATE INDEX idx_admin_activity_logs_admin_id ON admin_activity_logs(admin_id);
CREATE INDEX idx_admin_activity_logs_created_at ON admin_activity_logs(created_at);

-- Create view for admin statistics
CREATE VIEW admin_stats AS
SELECT 
    (SELECT COUNT(*) FROM products) as total_products,
    (SELECT COUNT(*) FROM agenda) as total_agenda,
    (SELECT COUNT(*) FROM admin_users WHERE is_active = 1) as active_admins,
    (SELECT COUNT(*) FROM admin_activity_logs WHERE DATE(created_at) = CURDATE()) as today_activities;